<?php

if (!defined('APP_INCLUDE')) {
    die('invalid inclusion');
}

if (!empty($session->username)) {
    # First, check if this account has not expired yet
    if ($session->expires != '0' && $session->expires < time()) {
        echoNotice(
            "We're sorry. Your account ({$session->username}) expired on " . date(
                "d M Y",
                $session->expires
            ) . ". Please contact the system administrator. <a href=\"user_login/logout.php\">Logout</a>"
        );
        $database->updateUserField($session->username, "active", 0);
        exit();
    }

    # Now, check if the account is inactive
    if ($session->active != '1') {
        echoNotice(
            "We're sorry. Your account ({$session->username}) is currently inactive. Please contact the system administrator. <a href=\"user_login/logout.php\">Logout</a>"
        );
        exit();
    }
}

