<?php

class Subscriptions
{
    var $reports = [];
    var $formArray = [];
    var $subscripts = [];
    var $colors = [];

    function __construct()
    {
        $this->subscripts = $this->get_subscriptions();
        $this->global_sub = getGlobalSetting("DefaultSubscription", "");

        $this->colors = [
            "rgba(226,82,29,.5)",
            "rgba(119,189,57,.5)",
            "rgba(44,181,233,.5)",
            "rgba(233,165,38,.5)",
            "rgba(0,120,174,.5)",
            "rgba(255,0,0,.5)",
            "rgba(0,111,0,.5)",
            "rgba(0,221,34,.5)",
            "rgba(200,66,57,.5)",
            "rgba(249,113,247,.5)",
            "rgba(60,31,110,.5)",
            "rgba(46,136,10,.5)",
            "rgba(221,24,64,.5)",
            "rgba(252,218,0,.5)",
            "rgba(25,65,165,.5)",
            "rgba(175,216,248,.5)",
            "rgba(246,189,15,.5)",
            "rgba(139,186,0,.5)",
            "rgba(166,110,221,.5)",
            "rgba(249,132,161,.5)",
            "rgba(204,204,0,.5)",
            "rgba(153,153,153,.5)",
            "rgba(0,153,225,.5)",
            "rgba(255,102,204,.5)",
            "rgba(102,153,102,.5)",
            "rgba(124,124,180,.5)",
            "rgba(255,153,51,.5)",
            "rgba(152,0,255,.5)",
            "rgba(153,0,204,.5)",
            "rgba(204,204,0,.5)",
            "rgba(102,153,0,.5)"
        ];
    }

    function get_subscriptions()
    {
        global $db;
        @$result = $db->Execute("SELECT * FROM " . TBL_SUBSCRIPTIONS . "");
        $subs = [];

        if ($result !== false) {
            while ($row = $result->fetchRow()) {
                $value = json_decode($row["value"], true);
                $label = $row["name"];
                $value["id"] = $row["id"];
                $subs[$label] = $value;
            }
        }

        return $subs;
    }

    function install_subscription_system()
    {
        $this->createReportsTable();
        $this->createSubscriptionsTable();
        $this->createUserLogTable();
        $this->fillReportsTable();
    }

    function createReportsTable()
    {
        global $db;
        # Check if Reports table exists and create it if it doesn't
        $reports_table = "CREATE OR REPLACE TABLE  " . TBL_REPORTS . " (
			`id` INT PRIMARY KEY AUTO_INCREMENT,
			`filename` VARCHAR(255) UNIQUE KEY,
			`value` LONGTEXT
			) ENGINE=MyISAM  CHARSET=utf8;";
        $db->Execute($reports_table);
    }

    function createSubscriptionsTable()
    {
        global $db;

        # Check if subscription table exists and create it if it doesn't
        $subscription_table = "CREATE OR REPLACE TABLE  " . TBL_SUBSCRIPTIONS . " (
			`id` INT PRIMARY KEY AUTO_INCREMENT,
			`name` VARCHAR(255) UNIQUE KEY,
			`value` LONGTEXT
			) ENGINE=MyISAM  CHARSET=utf8;";
        $db->Execute($subscription_table);
    }

    function createUserLogTable()
    {
        global $db;

        # Check if userlog table exists and create it if it doesn't
        $userlog_table = "CREATE OR REPLACE TABLE  " . TBL__SUBSCRIPTIONS_USERLOG . " (
			`id` INT PRIMARY KEY AUTO_INCREMENT,
			`username` VARCHAR(255),
			`name` VARCHAR(255),
			`price` FLOAT(5,2),
			`timestamp` INT(11) NOT NULL default '0',
			`message` VARCHAR(255),
			KEY (`timestamp`)
			) ENGINE=MyISAM  CHARSET=utf8";
        $db->Execute($userlog_table);
    }

    function fillReportsTable()
    {
        global $db, $reports;

        # Insert Reports into reports table
        $insert_statement = "INSERT INTO " . TBL_REPORTS . " (`filename`,`value`) VALUES ";
        $first = 0;
        foreach ($reports as $label => $report) {
            $report["Label"] = $label;
            $filename = $report["Filename"];
            $value = json_encode($report);

            if ($first == 0) {
                $insert_statement .= "('{$filename}'," . $db->quote($value) . ")";
                $first = 1;
            } else {
                $insert_statement .= ",('{$filename}'," . $db->quote($value) . ")";
            }
        }
        $insert_statement .= " ON DUPLICATE KEY UPDATE value=VALUES(value)";
        $db->Execute($insert_statement);
    }

    function get_reports()
    {
        global $db;
        @$result = $db->Execute("SELECT * FROM " . TBL_REPORTS . "");
        if ($result !== false) {
            while ($row = $result->fetchRow()) {
                $value = json_decode($row["value"], true);
                $label = $value["Label"];
                unset($value["Label"]);
                $value["ReportID"] = $row["id"];
                $this->reports[$label] = $value;
            }
        }
    }

    function buildForm[]{
		global $db;
		$result = $db->Execute("SELECT * FROM ".TBL_SUBSCRIPTIONS."");		
		if($result !== false) {
			while($row = $result->fetchRow()){
				$value = json_decode($row["value"],true);
				$id = $row["id"];
				foreach($value as $k => $v){
					if($k == 'reports'){
						continue;
					}

$this->formArray[$id][$k]['value'] = $v['value'];
$this->formArray[$id][$k]['type'] = $v['type'];

if ($v['type'] == 'select') {
    $this->formArray[$id][$k]['options'] = $v['options'];
}
}
$this->formArray[$id]["Name"]["value"] = $row["name"];
}
}
}

function new_subscription($posts)
{
    global $db;
    foreach ($posts as $label => $val) {
        $label = explode("#", $label);

        if (isset($label[2])) {
            $opts = explode(",", $val);
            foreach ($opts as $num => $o) {
                $new_values[$label[0]]['options'][$num] = $o;
            }
            $new_values[$label[0]]['type'] = $label[1];
        } else {
            $new_values[$label[0]]['value'] = $val;
            $new_values[$label[0]]['type'] = $label[1];
        }
    }
    $name = $new_values["Name"]['value'];

    $value = json_encode($new_values);

    $db->Execute(
        "INSERT IGNORE INTO " . TBL_SUBSCRIPTIONS . " (`name`,`value`) VALUES (" . $db->quote($name) . "," . $db->quote(
            $value
        ) . ")"
    );
}

function edit_reports($subscrId, $reports)
{
    global $db;

    $result = $db->Execute("SELECT * FROM " . TBL_SUBSCRIPTIONS . " WHERE id={$subscrId}");
    $subscription = $result->fetchRow();
    $value = json_decode($subscription['value'], true);

    # Check if there are reports stored for this subscription. If so add them if not set them.
    $value['reports'] = $reports;

    $value = json_encode($value);
    $db->Execute("UPDATE " . TBL_SUBSCRIPTIONS . " SET value=" . $db->quote($value) . " WHERE id={$subscrId}");
}

function edit_subscription($posts)
{
    global $db;
    $subscrId = $posts["id#hidden"];
    $result = $db->Execute("SELECT * FROM " . TBL_SUBSCRIPTIONS . " WHERE id={$subscrId}");
    $subscription = $result->fetchRow();
    $value = json_decode($subscription['value'], true);
    if (isset($value['reports'])) {
        $new_values['reports'] = $value['reports'];
    }
    foreach ($posts as $label => $val) {
        $label = explode("#", $label);

        if (isset($label[2])) {
            $opts = explode(",", $val);
            foreach ($opts as $num => $o) {
                $new_values[$label[0]]['options'][$num] = $o;
            }
            $new_values[$label[0]]['type'] = $label[1];
        } else {
            $new_values[$label[0]]['value'] = $val;
            $new_values[$label[0]]['type'] = $label[1];
        }
    }
    $name = $new_values["Name"]['value'];
    $value = json_encode($new_values);
    $db->Execute(
        "UPDATE " . TBL_SUBSCRIPTIONS . " SET value=" . $db->quote($value) . ", name=" . $db->quote(
            $name
        ) . " WHERE id={$subscrId}"
    );
}

function delete_subscription($id, $setto)
{
    global $db;
    if ($setto == 0) {
        $db->Execute("UPDATE " . TBL_USERS . " SET subscriptionid = null WHERE subscriptionid= {$id}");
    } else {
        $db->Execute("UPDATE " . TBL_USERS . " SET subscriptionid = {$setto} WHERE subscriptionid= {$id}");
    }
    $db->Execute("DELETE FROM " . TBL_SUBSCRIPTIONS . " WHERE id = {$id}");
}

function ui_report_list()
{
    $this->get_reports();
    foreach ($this->reports as $l => $r) {
        if (defined($l)) {
            echo "<li class='' rel='{$r["ReportID"]}' src='{$r["Filename"]}'><span class='reportname'>" . constant(
                    $l
                ) . " <span class='small pull-right'>(" . constant($r["Category"]) . ") </span></span></li>";
        } else {
            dump($l);
        }
    }
}


function ui_delete_form()
{
    echo "Your are about to delete a subscription <b class='subscription_tag'>(#SUBSCRIPTION#)</b>:<br/>";

    echo "What do you want to do with the users that are using this subscription?</br><br/>";
    echo "By just removing the subscription the users will be able to see all the reports.<br/>";
    echo "<br/><form method='POST'><select name='deletesub'><option value='0'>Remove the subscription*</option>";
    foreach ($this->subscripts as $name => $values) {
        echo "<option class='remove-{$name}' value='{$values["id"]}'>Set user subscriptions to: {$name}</option>";
    }
    echo "</select><br/>";
    echo "<input type='hidden' value='' id='subtodelete' name='subtodelete' />";
    echo "<div style='float:left; margin-top:30px; width:100%'>";
    echo "<div class='form-group'><button class=\"btn btn-primary estimate-button delete-button\">" . _DELETE . "</button></div>";
    echo "<div class='form-group'><button class=\"btn btn-default estimate-button cancel-reset\">" . _CANCEL . "</button></div>";
    echo "</div></form>";
}

function ui_edit_form()
{
    global $form;
    $this->buildForm[];
    foreach ($this->formArray as $id => $data) {
        $data["subedit"]["value"] = "Save Changes";
        $data["subedit"]["type"] = "submit";
        $data["id"]["value"] = $id;
        $data["id"]["type"] = "hidden";

        $form->CreateForm($data, "edit-sub-$id custom-form");
    }
}

function ui_subscription_list()
{
    if (empty($this->subscripts)) {
        echo "<p class='no-subs-text'>" . _NO_SUBSCRIPTION_INFO . "</p>";
        return;
    }

    $i = 0;
    foreach ($this->subscripts as $name => $values) {
        $default = "fa-bookmark-o";
        if ($values['id'] == $this->global_sub) {
            $default = "fa-bookmark";
        }

        echo "<li><div style='background-color: {$this->colors[$i]};' class='subscriptionname selected' name='{$name}' rel='{$values["id"]}'><span class='name'>{$name}</span>";
        echo "<a class='default-subscription' title='Mark as Default' name='{$name}' rel='{$values["id"]}'><i class='fa {$default}'></i></a>";
        echo "<a class='delete-subscription' title='Delete this subscription' name='{$name}' rel='{$values["id"]}'><i class='fa fa-trash-o'></i></a>";
        echo "<a class='copy-subscription' title='Copy this subscription' name='{$name}'><i class='fa fa-copy'></i></a>";
        echo "<a class='edit-subscription' title='Edit this subscription' name='" . $name . "' rel='" . $values["id"] . "' price='" . @$values["Price"]['value'] . "'><i class='fa fa-edit'></i></a>";
        echo "</div><ul class='subscriptioncontent'>";
        if (!empty($values["reports"])) {
            $this->get_reports();
            foreach ($this->reports as $l => $r) {
                if (in_array($r["ReportID"], $values["reports"])) {
                    echo "<li class='' rel='{$r["ReportID"]}' src='{$r["Filename"]}'><span class='reportname'>" . constant(
                            $l
                        ) . "</span></li>";
                }
            }
        }
        echo "</ul>
			</li>";
        $i++;
    }
}

function new_subscription_form()
{
    global $form;

    $this->buildForm[];

    if (empty($this->formArray[0])) {
        $this->formArray[0] = [
            "id" => ["value" => 0, "type" => "hidden"]
        ,
            "Name" => ["value" => "", "type" => "input"]
            // ,"Display_Price" => array("value" => "","type" => "input")
        ,
            "Price" => ["value" => "", "type" => "input"]
        ,
            "KPI Limit" => ["value" => "", "type" => "input"]
        ,
            "PDF" => ["value" => "", "type" => "select", "options" => ["Enabled", "Disabled"]]
        ,
            "Dashboards" => ["value" => "", "type" => "select", "options" => ["Enabled", "Disabled"]]
        ,
            "Update" => ["value" => "", "type" => "select", "options" => ["Enabled", "Disabled"]]
        ];
    }

    $num = 0;
    $getfromsub = 0;
    foreach ($this->formArray as $subscrip => $vals) {
        if (count($vals) > $num) {
            $num = count($vals);
            $getfromsub = (int)$subscrip;
        }
    }
    $data = [];
    if (isset($this->formArray[$getfromsub])) {
        foreach ($this->formArray[$getfromsub] as $k => $v) {
            $data[$k]['value'] = '';
            if (isset($v['type'])) {
                $data[$k]['type'] = $v['type'];
            } else {
                $data[$k]['type'] = '';
            }
            if (isset($v['options'])) {
                $data[$k]['options'] = $v['options'];
            }
        }
    }

    $data["subsave"]["value"] = "Add New Subscription";
    $data["subsave"]["type"] = "submit";

    $form->CreateForm($data, "new-sub-form custom-form");
}

function getSubscription($name)
{
    global $db;
    $result = $db->Execute("SELECT * FROM " . TBL_SUBSCRIPTIONS . " where name = " . $db->Quote($name) . "");
    if ($result !== false) {
        $row = $result->fetchRow();
        return $row;
    }
}


function copySubscription($source, $target)
{
    global $db;
    $data = $this->getSubscription($source);
    $value = $data['value'];
    $db->Execute(
        "INSERT IGNORE INTO " . TBL_SUBSCRIPTIONS . " (`name`,`value`) VALUES (" . $db->quote(
            $target
        ) . "," . $db->quote($value) . ")"
    );
}
}
?>