<?php

require_once '../../AccessControl.php';

function ProfileListMenu()
{
    global $db, $session, $validUserRequired;

    $where = "";
    if ($validUserRequired && !$session->isAdmin() && !$session->allProfiles) {
        $validprofiles = [];
        for ($i = count($session->user_profiles) - 1; $i >= 0; $i--) {
            $validprofiles[] = $db->Quote($session->user_profiles[$i]);
        }
        if (empty($validprofiles)) {
            return [];
        }
        $where = " where profilename in (" . implode(",", $validprofiles) . ")";
    }
    $limitsql = "LIMIT 5";
    // if (defined("_LIMIT_PROFILES") != 0 && _LIMIT_PROFILES < 5) {
    // 	$limitsql = "LIMIT "._LIMIT_PROFILES;
    // } else {

    //          }

    $q = $db->Execute(
        "SELECT profilename, activated FROM " . TBL_PROFILES . " $where ORDER BY lastused DESC $limitsql"
    );
    $p = [];
    while ($data = $q->fetchRow()) {
        $p[] = [$data[0], $data[1]];
    }
    return $p;
}

if ($session->isAdmin()) {
    $q = $db->Execute("SELECT count(*) FROM " . TBL_PROFILES);
    $data = $q->fetchRow();
    $pcount = $data[0];
} else {
    $pcount = count($session->user_profiles);
}
$plist = ProfileListMenu();

$getdatafromstore = true;
$storeReportsData = json_decode(getGlobalSetting("StoreReportData", "[]"), true);
# Do we have data saved for the store reports?
if (!empty($storeReportsData['time'])) {
    # has it been less than a day ?
    if (time() - $storeReportsData['time'] < 86400) {
        $getdatafromstore = false;
    }
}

$usage_tracking = getGlobalSetting("UsageTracking", 1);

$version_help = getVersion();

$lang_labels = [
    "HELP_VERSION_DETAILS" => $version_help,
    "LOGAHOLIC_VERSION_NUMBER" => LOGAHOLIC_VERSION_NUMBER,
    "_VERSION_NUMBER" => str_replace(".", "", LOGAHOLIC_VERSION_NUMBER),
    "USER_AUTHENTICATION_OTHER" => USER_AUTHENTICATION_OTHER,
    "_LAST_CHANCE_TO_CANCEL" => _LAST_CHANCE_TO_CANCEL,
    "_EDIT_USER" => _EDIT_USER,
    "_WARNING_INSERT_REPORT_IN_ALL_PROFILES" => _WARNING_INSERT_REPORT_IN_ALL_PROFILES,
    "_DO_YOU_REALLY_WANT_TO_DELETE_DOWNLOAD" => _DO_YOU_REALLY_WANT_TO_DELETE_DOWNLOAD,
    "_YOUR_ORDER_IS_PENDING_PLEASE_WAIT" => _YOUR_ORDER_IS_PENDING_PLEASE_WAIT,
    "_IF_YOU_CAN_NOT_DOWNLOAD_CONTACT_SALES" => _IF_YOU_CAN_NOT_DOWNLOAD_CONTACT_SALES,
    "_YOUR_ORDER_HAS_THE_FOLLOWING_STATUS" => _YOUR_ORDER_HAS_THE_FOLLOWING_STATUS,
    "_YOU_ARE_NOT_YET_ALLOWED_TO_DOWNLOAD" => _YOU_ARE_NOT_YET_ALLOWED_TO_DOWNLOAD,
    "_IF_YOU_HAVE_QUESTIONS_CONTACT_SALES" => _IF_YOU_HAVE_QUESTIONS_CONTACT_SALES,
    "_CONTROL_PANEL" => _CONTROL_PANEL,
    "_DELETED" => _DELETED,
    "_SUBSCRIPTIONS" => _SUBSCRIPTIONS,
    "_REINSTALL" => _REINSTALL,
    "_NOTHING_FOUND_FOR_THIS_UNLOCK_KEY" => _NOTHING_FOUND_FOR_THIS_UNLOCK_KEY,
    "_YOU_CAN_OBTAIN_UNLOCK_KEYS_BY_PURCHASING_REPORTS" => _YOU_CAN_OBTAIN_UNLOCK_KEYS_BY_PURCHASING_REPORTS,
    "_WHERE_TO_FIND_YOUR_UNLOCK_KEY" => _WHERE_TO_FIND_YOUR_UNLOCK_KEY,
    "_KPI_LIMIT_ERROR" => _KPI_LIMIT_ERROR,
    "_MOVE_TO_DONE_ASSURANCE" => _MOVE_TO_DONE_ASSURANCE,
    "_INVALID_SUBSCRIPTION_NAME" => _INVALID_SUBSCRIPTION_NAME,
    "_UPDATE_RUNNING_INFO" => _UPDATE_RUNNING_INFO,
    "_ADMIN_USERNAME" => _ADMIN_USERNAME,
    "_NEVER" => _NEVER,
    "_SURE_TO_DELETE_USER" => _SURE_TO_DELETE_USER,
    "_LOGAHOLIC_EDITION" => _LOGAHOLIC_EDITION,
    "_EDITION" => $edition[_LOGAHOLIC_EDITION],
    "_ACTIVATE_ALL_PROFILES_CONFIRM" => _ACTIVATE_ALL_PROFILES_CONFIRM,
    "_MOVE_YOUR_MOUSE_FOR_HELP" => _MOVE_YOUR_MOUSE_FOR_HELP,
    "_NON_ROOT_RECOMMENDED" => _NON_ROOT_RECOMMENDED,
    "_PROFILE" => _PROFILE,
    "_TABLE" => _TABLE,
    "_USER" => _USER,
    "_VISITS" => _VISITS,
    "_AVG_VISITS_DAY" => _AVG_VISITS_DAY,
    "_DATE_FROM" => _DATE_FROM,
    "_DATE_TO" => _DATE_TO,
    "_LAST_UPDATED" => _LAST_UPDATED,
    "_SEARCH" => _SEARCH,
    "_SEARCH_PROFILES_MATCHING" => _SEARCH_PROFILES_MATCHING,
    "_ESTIMATE_CONFIRM" => _ESTIMATE_CONFIRM,
    "_EDIT_PROFILE" => _EDIT_PROFILE,
    "_HANDLING_BY_ADMIN" => _HANDLING_BY_ADMIN,
    "_SAVE_BEFORE_TRACKER" => _SAVE_BEFORE_TRACKER,
    "_ALERT_ADDED" => _ALERT_ADDED,
    "_ALERT_REMOVED" => _ALERT_REMOVED,
    "_EXPORTING_FILES" => _EXPORTING_FILES,
    "_UPDATING_COUNTRIES" => _UPDATING_COUNTRIES,
    "_PATH_NOT_WRITEABLE" => _PATH_NOT_WRITEABLE,
    "_INVALID_EMAIL" => _INVALID_EMAIL,
    "_PASSWORD_EXPLAIN" => _PASSWORD_EXPLAIN,
    "_PASSWORD_ENCRYPTION" => _PASSWORD_ENCRYPTION,
    "_COMPLETE" => _COMPLETE,
    "_LOADING" => _LOADING,
    "_PROFILENAME" => _PROFILENAME,
    "_PREVIEW" => _PREVIEW,
    "_PATH_NOT_WRITEABLE" => _PATH_NOT_WRITEABLE,
    "_TODAY" => _TODAY,
    "_YESTERDAY" => _YESTERDAY,
    "_LAST_7_DAYS" => _LAST_7_DAYS,
    "_LAST_30_DAYS" => _LAST_30_DAYS,
    "_THIS_MONTH" => _THIS_MONTH,
    "_LAST_MONTH" => _LAST_MONTH,
    "_LAST_3_MONTHS" => _LAST_3_MONTHS,
    "_THIS_YEAR" => _THIS_YEAR,
    "_LAST_YEAR" => _LAST_YEAR,
    "_CUSTOM_RANGE" => _CUSTOM_RANGE,
    "_SOMETHING_WRONG_W_COLLECTING" => _SOMETHING_WRONG_W_COLLECTING,
    "_SEARCH_USER_OR_PROFILES" => _SEARCH_USER_OR_PROFILES,
    "_UPDATE_FINISHED_W_ERRORS" => _UPDATE_FINISHED_W_ERRORS,
    "_USER_STOPPED_UPDATE" => _USER_STOPPED_UPDATE,
    "_EMPTY_PASSWORD" => _EMPTY_PASSWORD,
    "_EMPTY_PASSWORD2" => _EMPTY_PASSWORD2,
    "_EMPTY_EMAIL" => _EMPTY_EMAIL,
    "_TYPE_TO_ADD_PROFILE" => _TYPE_TO_ADD_PROFILE,
    "_PASSWORDS_DONT_MATCH" => _PASSWORDS_DONT_MATCH,
    "_ERROR_REGISTRATION" => _ERROR_REGISTRATION,
    "_SUCCESS_ADD_SUBSCRIPTION" => _SUCCESS_ADD_SUBSCRIPTION,
    "_SUCCESS_DELETE_SUBSCRIPTION" => _SUCCESS_DELETE_SUBSCRIPTION,
    "_SUCCESS_EDIT_SUBSCRIPTION" => _SUCCESS_EDIT_SUBSCRIPTION,
    "_SUCCESS_MADE_COPY" => _SUCCESS_MADE_COPY,
    "_SUBSCRIPTION_MARKED_DEFAULT" => _SUBSCRIPTION_MARKED_DEFAULT,
    "_DISPLAY_ERROR" => _DISPLAY_ERROR,
    "_SEND_ERROR_REPORT" => _SEND_ERROR_REPORT,
    "_CAUSED_BY_OUTPUT" => _CAUSED_BY_OUTPUT,
    "_UNEXPECTED_INTERNAL_ERROR" => _UNEXPECTED_INTERNAL_ERROR,
    "_MEMBER_SINCE" => _MEMBER_SINCE,
    "_DATAM_PROCESS" => _DATAM_PROCESS,
    "_NO_ARCHIVE_FILES" => _NO_ARCHIVE_FILES,
    "_AUTH_METH_SET_TO" => _AUTH_METH_SET_TO,
    "_SEARCH_SETTINGS" => _SEARCH_SETTINGS,
    "_IMPORT_PROFILE_BAD_RESPONSE" => _IMPORT_PROFILE_BAD_RESPONSE,
    "_DASHBOARD_AUTOSAVED_ON" => _DASHBOARD_AUTOSAVED_ON,
    "_DASHBOARD_NAME_EXISTS" => _DASHBOARD_NAME_EXISTS,
    "_SUBSCRIPTION_UPGRADE_NOTICE" => _SUBSCRIPTION_UPGRADE_NOTICE,
    "_DASHBOARDS" => _DASHBOARDS,
    "_UPGRADE_NOW" => _UPGRADE_NOW,
    "_NO_PERMISSION" => _NO_PERMISSION,
    "_DISABLED" => _DISABLED,
    "_CAN_VIEW_ALL_PROFILES" => _CAN_VIEW_ALL_PROFILES,
    "_PAY" => _PAY,
    "_MONTH" => _MONTH,
    "_YEAR" => _YEAR,
    "_CREATE_NEW_PROFILE" => _CREATE_NEW_PROFILE,
    "_SHOW" => _SHOW,
    "_PREVIOUS" => _PREVIOUS,
    "_NEXT" => _NEXT,
    "_HELP" => _HELP
];
