<?php

$accessControl = [
    "ProfileRequired" => true
];
require_once '../../AccessControl.php';

$geopath = "../../";
include_once("../../components/geoip/open_geoip.php");
include_once "../../includes/editvisitors_class.php";

if (!$session->canEditProfiles()) {
    die('{ "Status" : "Error", "Message" : "' . _SORRY_NO_PERMISSIONS . '" }');
}

$editvisitor = new editVisitor();

$id = $id ?? $_POST['id'];
$label = $label ?? $_POST['label'];
$visitorid = $visitorid ?? $_POST['visitorid'];
$ipnumber = $ipnumber ?? $_POST['ipnumber'];
$action = $action ?? $_POST['action'];
$setting = $setting ?? $_POST['setting'];

if (empty($action)) {
    die('{ "Status" : "Error", "Message" : "' . _INVALID_PARAMS . '" }');
}

if ($action == "editvisitorid") {
    if (empty($visitorid)) {
        die('{ "Status" : "Error", "Message" : "' . _INVALID_VID . '" }');
    }
    $data = $editvisitor->EditVisitorId($visitorid);
    if (empty($data)) {
        die('{ "Status" : "Error", "Message" : "' . _INVALID_VID . '" }');
    } else {
        die('{ "Status" : "Success", "Data" : ' . json_encode($data) . ' }');
    }
} elseif ($action == "savevisitor") {
    if (empty($id) || empty($label) || empty($setting)) {
        die('{ "Status" : "Error", "Message" : "' . _INVALID_PARAMS . '" }');
    }

    $editvisitor->updateLabel($id, $label);

    $msg = _UPDATED_VID_TO . " : $label";

    # Fetch visitordata before changing its crawl option.
    $data = $editvisitor->getData('id', $id);

    if ($setting == "bot") {
        $crawl = 1;
    } else {
        $crawl = 0;
    }
    $editvisitor->updateSetting($crawl, $id);

    if ($data[0]['crawl'] != $crawl) {
        $msg .= "<br/>" . str_replace("%X%", $setting, _IDENTIFIED_VID_AS_X);
    }
    die('{ "Status" : "Success", "Message" : "' . $msg . '" }');
}
