<?php

include("files/global.php");

# validate our input variables
if (isset($_REQUEST['conf']) && strpos(";", $_REQUEST['conf']) === false) {
    $conf = $_REQUEST['conf'];
} else {
    die('invalid input');
}

if (isset($_REQUEST['testid']) && is_numeric($_REQUEST['testid'])) {
    $testid = (int)$_REQUEST['testid'];
} else {
    die('invalid input');
}

if (isset($_REQUEST['vmethod']) && is_numeric($_REQUEST['vmethod'])) {
    $visitormethod = (int)$_REQUEST['vmethod'];
} else {
    die('invalid input');
}

if (isset($_REQUEST['jsmode']) && is_numeric($_REQUEST['jsmode'])) {
    $jsmode = (int)$_REQUEST['jsmode'];
} else {
    die('invalid input');
}

if (isset($mysqlprefix) && !empty($mysqlprefix)) {
    $check = str_replace($mysqlprefix, "", $_REQUEST['tn']);
} else {
    $check = $_REQUEST['tn'];
}

if (isset($_REQUEST['tn']) && substr($check, 0, 1) == "p" && is_numeric(substr($check, 1))) {
    $tn = $mysqlprefix . "p" . (intval(substr($check, 1)));
} else {
    die('invalid input');
}

$cookiename = "lg" . $conf . $testid;

include_once("includes/table_definitions.php");
require_once("vendor/adodb/adodb-php/adodb.inc.php");

if (function_exists("mysqli_connect")) {
    $db = ADONewConnection("mysqli");
} else {
    $db = ADONewConnection("mysql");
}
$db->Connect($mysqlserver, $mysqluname, $mysqlpw, $DatabaseName);

//get data
$sptablename = $tn . "_splittests";
$sptablename_results = $tn . "_splittests_results";


$q = "select * from `$sptablename` where id= ?";
$q = $db->Execute($q, [$testid]);
$data = $q->fetchRow();

//split traffic
if (!isset($_COOKIE[$cookiename])) {
    // New User: determine which content to present and store the choice in a cookie
    if (!$data['splitperc']) {
        $data['splitperc'] = 50;
    }
    $stest = rand(0, 100);
    if ($stest < (100 - $data['splitperc'])) {
        SetCookie($cookiename, "A", time() + 8640000, "/", $_SERVER['HTTP_HOST'], 0);
        $splittester = "A";
    } else {
        SetCookie($cookiename, "B", time() + 8640000, "/", $_SERVER['HTTP_HOST'], 0);
        $splittester = "B";
    }
}
//echo $$cookiename . " ($cookiename)<P>";

// Get some variables to track
$ipnumber = $_SERVER["REMOTE_ADDR"];
$useragent = $_SERVER['HTTP_USER_AGENT'];
$timestamp = time();

if ($visitormethod == 1) {
    $visitorid = md5($ipnumber);
} else {
    if ($visitormethod == 3 && isset($_COOKIE['NewLogaholic_VID'])) {
        $visitorid = md5($_COOKIE['NewLogaholic_VID']);
    } else {
        $visitorid = md5($ipnumber . ':' . $useragent);
    }
}

//spit content & update stats
if (@$_COOKIE[$cookiename] == "A" || @$splittester == "A") {
    //$q = "insert into $sptablename_results set testid='$testid', visitorid='$visitorid',timestamp='$timestamp',page='A'";
    $q = "insert into `$sptablename_results` set testid= ?, visitorid= ?, timestamp= ?, page='A'";
    $db->Execute($q, [$testid, $visitorid, $timestamp]);
    if (@$jsmode) {
        $clean = $data['pagea'];
    } else {
        echo stripslashes($data['pagea']);
    }
} else {
    $q = "insert into `$sptablename_results` set testid= ?, visitorid= ?, timestamp= ?, page='B'";
    $db->Execute($q, [$testid, $visitorid, $timestamp]);
    if (@$jsmode) {
        $clean = $data['pageb'];
    } else {
        echo stripslashes($data['pageb']);
    }
}
if ($clean) {
$clean = str_replace("\n", "", $clean);
$clean = str_replace("\r", "", $clean);
$clean = str_replace(chr(10), " ", $clean); //remove carriage returns
$clean = str_replace(chr(13), " ", $clean); //remove carriage returns


if ($jsmode == 1) {
    echo "document.getElementById(\"abtester\").innerHTML=\"" . str_replace("\"", "\\\"", $clean) . "\";";
} else {
if ($jsmode == 2) {
?>
function createNewDoc()
{
var newDoc=document.open("text/html","replace");
var txt="<?php
echo str_replace("\"", "\\\"", $clean); ?>";
newDoc.write(txt);
newDoc.close();
}

if (document.all) {
document.write('
<body onload="createNewDoc()">');
} else {
document.write('
<body>');
createNewDoc();
}

<?php
}
}
}
?>
