<?php


$reports["_UTM_TERM"] = Array(
	"ClassName" => "UtmTerm", 
	"Category" => "_ADVERTISING", 	
	"Options" => "daterangeField,profileselector,displaymode,search,limit,columnSelector,human",
	"Filename" => "utm_term",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class UtmTerm extends Report {

	function Settings() {		
		//$this->datafiles=false;
		

		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table";
		$this->columnDefinitions[] = array("Label" => "Term", "actionmenu" => "utm_term");
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");		
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;
		$this->help=_UTM_DESC;

	}

	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query  = "select lg_getparam('utm_term',u.params) as src, count(*) as hits, count(distinct sessionid) as visits from {$tablename} as a, {$this->profile->tablename_urlparams} as u where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." and a.params=u.id and u.params like '%utm_term=%' group by src order by hits desc";
		
		return $query;
	}

	

	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>
