<?php

/**
* @desc This report displays a small twitter feed.
*/

$reports["_TWITTER_FEED"] = Array(
    "ClassName" => "TwitterFeed", 
    "Category" => "_TWITTER", 
    "icon" => "images/icons/32x32/twitter_feed.png",
	"Options" => "limit",
	"Filename" => "twitter_feed",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"DeleteOutdatedFiles" => false,
	"Update" => false
);

class TwitterFeed extends TwitterCore {

	function Settings() {
		$this->help = _TWITTER_FEED_DESC . ":<br/>
		<table class='table'>
			<tr></tr>
			<tr><td>watching now</td><td>". _FEED_CONTAINING_DESC_1 ."</td></tr>
			<tr><td>&quot;happy hour&quot;</td><td>". _FEED_CONTAINING_DESC_2 ."</td></tr>
			<tr><td>love OR hate</td><td>". _FEED_CONTAINING_DESC_3 ."</td></tr>
			<tr><td>beer -root</td><td>". _FEED_CONTAINING_DESC_4 ."</td></tr>
			<tr><td>#haiku</td><td>". _FEED_CONTAINING_DESC_5 ."</td></tr>
			<tr><td>from:alexiskold</td><td>". _FEED_CONTAINING_DESC_6 ."</td></tr>
			<tr><td>to:techcrunch</td><td>". _FEED_CONTAINING_DESC_7 ."</td></tr>
			<tr><td>@mashable</td><td>". _FEED_CONTAINING_DESC_8 ."</td></tr>
			<tr><td>superhero since:2015-07-19</td><td>". _FEED_CONTAINING_DESC_9 ."</td></tr>
			<tr><td>ftw until:2015-07-19</td><td>". _FEED_CONTAINING_DESC_10 ."</td></tr>
			<tr><td>movie -scary :)</td><td>". _FEED_CONTAINING_DESC_11 ."</td></tr>
			<tr><td>flight :(</td><td>". _FEED_CONTAINING_DESC_12 ."</td></tr>
			<tr><td>traffic ?</td><td>". _FEED_CONTAINING_DESC_13 ."</td></tr>
			<tr><td>hilarious filter:links</td><td>". _FEED_CONTAINING_DESC_14 ."</td></tr>
			<tr><td>news source:twitterfeed</td><td>". _FEED_CONTAINING_DESC_15 ."</td></tr>
		</table>";
	}
	
	function DisplayCustomForm(){
		if(!empty($this->keyword)) {
			$keyword = $this->keyword;
		} else {
			$keyword = '';
		}
		return "<div class='form-group'><label for='keyword'>". _INSERT_KEYWORD . "</label><input type='text' id='keyword' class='report_option_field form-control' name='keyword' value='{$keyword}' /></div>";
	}
	
	function GetReportData(){
		$this->addlabel = "Search: ";		
		$this->displayReportButtons = false;
		if(empty($this->keyword)){	
			return [];
		}		
		$this->addlabel .= $this->keyword;
		
		$search = $this->keyword;
		$data = [];
		$tweets = $this->TwitterCall("search", urlencode($search));
		if(empty($tweets['statuses'])){
			return [];
		}

		if($this->limit > 200){
			echoNotice(_LIMIT_MAX_200);
			$this->limit = 200;
		}
		$i = 0;
		foreach ($tweets['statuses'] as $tweet) {
			if($i < $this->limit){
				$data[] = array(
					"id" => $tweet['id']
					,"retweets" => $tweet['retweet_count']
					,"favorites" => $tweet['favorite_count']
					,"date" => $tweet['created_at']
					,"author" => $tweet['user']['name']
					,"author-url" => $tweet['user']['screen_name']
					,"content" => $tweet['text']
					,"image" => $tweet['user']['profile_image_url']
					,"country" => $tweet['metadata']['iso_language_code']	
				);
				$i++;
			}
		}
		return $data;
	}

	function DisplayReport() {
		$data = $this->GetReportData();
		$this->ReportHeader();
		if(empty($this->keyword)){
			echoNotice($this->SettingsButton()._INSERT_KEYWORD); 
			return false;
		}

		if(empty($data)){
			echo _NO_TWEETS_FOUND . "..";
		}

		echo '<ul class="timeline">';

		foreach($data as $tweet){
			# Icon        
		    echo "<li><i class='fa fa-twitter bg-blue'></i>
			    <div class='timeline-item'>
		            <span class='time'><i class='fa fa-clock-o'></i> {$tweet["date"]}</span>

		            <h3 class='timeline-header'>By: <a href='https://twitter.com/{$tweet['author-url']}' target='_blank'>{$tweet["author"]}</a></h3>

		            <div class='timeline-body'>
		                {$tweet["content"]}
		            </div>

		            <div class='timeline-footer'>
		                <a class='btn btn-primary btn-xs'>Retweets: {$tweet["retweets"]}</a>
		            </div>
		        </div>
	        </li>";
		}
		echo '</ul>';
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>