<?php

/**
* @desc Definitions for this report: Traffic Breakdown

    "Referring Sites" are visitors that came to your site via a link on another site. "Direct Traffic" are visitors that manually entered the URL of your website in the address bar. "Search Engines" are visitors that came to your site via a search engine, for example Google
    Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
*/
$reports["_TRAFFIC_BREAKDOWN"] = Array(
	"ClassName" => "TrafficBreakdown", 
	"Category" => "_TRAFFIC_SOURCES", 
	"icon" => "images/icons/32x32/traffic_breakdown.png",
	"Options" => "daterangeField,profileselector,displaymode,columnSelector",
	"Filename" => "traffic_breakdown",
	"Distribution" => "Standard",
	"Order" => 1,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
);

class TrafficBreakdown extends Report {

	function Settings() {
		$this->DefaultDisplay = "stream";
		$this->DisplayModes = "table,pie,stream";
		$this->columnDefinitions[] = array("Label" => _TRAFFIC_SOURCES);
		$this->columnDefinitions[] = array("Label" => _VISITS);
		$this->columnDefinitions[] = array("Label" => _VISIT_SHARE);
		$this->help = _TRAFFIC_BREAKDOWN_DESC;
		$this->sort = false;
		$this->chartoptions = array("stacked_graph_style" => "expand", "stacked_showcontrols" => true, "showlegend" => true, "yFormat" => ",.0f");
		if (@$this->displaymode == "stream") {
			$this->remove_outputmodes = array("xml","csv","mail");
		}
	}

	function GetReportData() {
		
		if (@$this->displaymode == "stream") {			
			$this->dataCollectType = "days";
			$this->createDataFiles($this->from,$this->to);
			$d = $this->getTrendDataFromFiles($this->DataFiles($this->from,$this->to));
			$this->trenddata = true;			
			return $d;

		}

		$d = parent::GetReportData();
		$data = [];
		$tot = 0;
		foreach($d as $val){
			$tot = $tot + $val[1];
		}
		$i = 0;
		foreach($d as $val){
			$data[$i][0]  = $val[0];
			$data[$i][1]  = $val[1];
			$data[$i][2]  = ($val[1] / $tot) * 100;
			$i ++;
		}		
		return $data;
	}
	function GetDataFromDb() {
		global $db;
		
		$db->Execute("SET SESSION group_concat_max_len = 65535");
		$subq=$this->profile->tablename."_breakdown";
        $q = "create temporary table $subq select sessionid, SUBSTRING_INDEX(GROUP_CONCAT(referrer),',',1) as referrer, SUBSTRING_INDEX(GROUP_CONCAT(keywords),',',1) as keywords from {$this->profile->tablename} where timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) ." group by sessionid";
        

        try {
			error_reporting(0); 
			if($db->Execute($q) === false){
				throw new Exception();
			}

			# error reporting
			if (LOGAHOLIC_VERSION_STATUS=="release") {  
				error_reporting(E_ALL & ~E_NOTICE);    
			} else {
				error_reporting(E_ALL);
			}

			$q = "select count(*) from $subq where keywords!=(select id from {$this->profile->tablename_keywords} where keywords='')";
	        $q = $db->Execute($q);
	        $data = $q->FetchRow();
	        $search_traffic = $data[0];
	        
	        # get the direct traffic
	        $q = "select count(*) from $subq where referrer=(select id from {$this->profile->tablename_referrers} where referrer='-')";
	        $q = $db->Execute($q);
	        $data = $q->FetchRow();
	        $direct_traffic = $data[0];
	        
	        # get the referrer traffic (which is the rest) 
	        $q = "select (count(*)-($search_traffic+$direct_traffic)) from $subq";
	        $q = $db->Execute($q);
	        $data = $q->FetchRow();
	        $referrer_traffic = $data[0];
	        
	        $db->Execute("drop table $subq");
	        
	        $total=$referrer_traffic+$direct_traffic+$search_traffic;
			
	        $data = [];
	        if($total != 0){
				$data[0][0]="Referring Sites";
				$data[0][1]=$referrer_traffic;
				$data[1][0]="Direct Traffic";
				$data[1][1]=$direct_traffic;
				$data[2][0]="Search Engines";
				$data[2][1]=$search_traffic;
	        }
			return $data;
			


			
		} catch(Exception $e){
			return [];
		}
      
        
	}

	function DisplayReport() {

		if ($this->displaymode!=="stream") {
			parent::DisplayReport();
			return;
		}
		$this->ReportHeader();

		$data = $this->GetReportData();

		$md5_time = md5(time());
		$container_id = 'stac'.$md5_time.rand(1,1000);	

		$this->StackedAreaChart($data);	
	}

	function AggregateFixData($data, $num_profiles) {
		$tot = 0;
		foreach($data as $val){
			$tot = $tot + $val[1];
		}		
		foreach($data as $k => $val){			
			$data[$k][2]  = ($tot == 0) ? 0 : ($val[1] / $tot) * 100;				
		}
		return $data;
	}

}
?>
