<?php

/**
* @desc Definitions for this report: Visitors per Hour

    Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
    Pageviews: The total number of pages requested (excluding any bots and crawlers).
    Pages per user: The total number of pages devided by the number of visitors.

Tip: When viewing more than one day, keep in mind that you are seeing summed up totals for that hour for each day in your date range. 
*/

$reports["_TOP_HOURS"] = Array(
	"ClassName" => "TopHours", 
	"Category" => "_VISITOR_TRENDS", 
	"icon" => "images/icons/32x32/visitorsperhour.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,columnSelector,human",
	"Filename" => "top_hours",
	"Distribution" => "Premium",
	"Order" => 7,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class TopHours extends Report {
	function Settings() {
		$this->DefaultDisplay = "barchart";
		$this->DisplayModes = "table,barchart";
		$this->columnDefinitions[] = array("Label" => "_HOUR");
		$this->columnDefinitions[] = array("Label" => "_VISITS", "line_order" => 0);
		$this->columnDefinitions[] = array("Label" => "_PAGEVIEWS", "line_order" => 1, "disable_line" => "true");
		$this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT", "totalRow" => "avg", "disable_line" => "true", "show_line" => false);		
		$this->columnDefinitions[] = array("Label" => "_VISITORS", "line_order" => 2, "totalRow" => "none", "disable_line" => "true", "hide_column" => true);
		$this->barcolors = array("#fdae6b","#fdd0a2");
		
		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul>'.'<li>'._VISITS_DEFINITION.'<li>'._PAGEVIEWS_DEFINITION.'<li>'._PAGES_PER_USER_DEFINITION.'<li>'._VISITORS_DEFINITION . '</ul><div class=\'indentbody\'>'._VISITORS_PER_HOUR_TIP.'</div>';
		$this->key_col = 0;
	}
	
	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$query  = "SELECT FROM_UNIXTIME(timestamp, '%H') AS hours, COUNT(DISTINCT sessionid) AS visits, COUNT(*) AS pages, (COUNT(*) / COUNT(DISTINCT sessionid)) AS ppu,COUNT(DISTINCT visitorid) AS visitors FROM {$tablename} WHERE timestamp >= ". $db->quote($this->from) ." AND timestamp <= ". $db->quote($this->to) ." GROUP BY hours ORDER BY hours";
		 

		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}
?>
