<?php

/**
* @desc This report displays a overview of your top entry pages
*/
$reports["_TOP_ENTRY_PAGES"] = Array(
	"ClassName" => "TopEntryPages", 
	"Category" => "_POPULAR_CONTENT", 
	"icon" => "images/icons/32x32/topentrypages.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,limit,columnSelector,human",
	"Filename" => "top_entry_pages",
	"Distribution" => "Premium",
	"Order" => 4,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"canAggregate" => false
);

class TopEntryPages extends Report {
	
	function Settings() {
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,pie";
		$this->columnDefinitions[] = array("Label" => "_PAGE","actionmenu" => 'page');
		$this->columnDefinitions[] = array("Label" => "_VISITS");
		$this->actionmenu_type = 'page';
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;

		$this->help = _DEFINITIONS_FOR_THIS_REPORT.':<ul><li>'._PAGE_TOPENTRYPAGES_DEFINITION.'</li><li>'._VISITS_TOPENTRYPAGES_DEFINITION.'</li></ul>';
	}
	
	function DefineQuery() {
		global $db, $databasedriver;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}
		
		if ($databasedriver == "sqlite") {
			$db->Execute("BEGIN TRANSACTION");
		}
		# slow, must optimize
		$pg="DROP TABLE IF EXISTS {$this->profile->tablename}_temptable_mindates";
		$db->Execute($pg);
		
        $pg="create temporary table {$this->profile->tablename}_temptable_mindates (min_sessionid char(32), min_timestamp int(11))";
        $db->Execute($pg);
        
        $pg=subsetDataToSourceID("insert into {$this->profile->tablename}_temptable_mindates select sessionid min_sessionid, min(timestamp) min_timestamp from {$tablename} where (timestamp >=". $db->quote($this->from) ." and timestamp <=". $db->quote($this->to) .") group by sessionid", $this->trafficsource);
		$db->Execute($pg);
        $subquery = subsetDataToSourceID("select a.url, count(distinct sessionid) as hits from {$this->profile->tablename}_temptable_mindates, {$tablename} as a where (sessionid = min_sessionid) and (timestamp = min_timestamp) group by a.url order by hits desc", $this->trafficsource);
        $query = "select IF(u.title = '',u.url,CONCAT(u.url,'##',u.title)) as urlinfo, hits from ($subquery) as a, {$this->profile->tablename_urls} as u where a.url=u.id"; 
        $this->applytrafficsource=false;
		return $query;
	}
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# because the query takes too long
		return false;		
	}
}
?>