<?php

/**
 * @desc This report displays a overview of your top continents
 */
$reports["_TOP_CONTINENTS"] = array(
    "ClassName" => "TopContinents",
    "Category" => "_LOCATIONS",
    "icon" => "images/icons/32x32/topcountriescities.png",
    "Options" => "daterangeField,profileselector,columnSelector,displaymode",
    "Distribution" => "Standard",
    "Filename" => "top_continents",
    "Order" => 1,
    "ReportVersion" => 1.0,
    "MinimumVersion" => 3.0,
    "EmailAlerts" => true,
    "Update" => false
);

class TopContinents extends Report
{

    function Settings()
    {
        $this->DefaultDisplay = "pie";
        $this->DisplayModes = "table,pie";
        $this->columnDefinitions[] = array("Label" => "_CONTINENT");
        $this->columnDefinitions[] = array("Label" => "_VISITS");
        $this->columnDefinitions[] = array("Label" => "_PAGEVIEWS");
        $this->columnDefinitions[] = array("Label" => "_PAGES_PER_VISIT", "totalRow" => "avg");
    }

    function GetReportData()
    {
        global $reports;
        $continents = array(
            "North America" => "AI,AG,AW,BS,BB,BZ,BM,VG,CA,KY,CR,CU,DM,DO,SV,GL,GD,GP,GT,HT,HN,JM,MQ,MX,MS,AN,NI,PA,PR,BL,KN,LC,MF,PM,VC,TT,TC,US,VI",
            "South America" => "AR,BO,BR,CL,CO,EC,FK,GF,GY,PY,PE,SR,UY,VE",
            "Europe" => "AX,AL,AD,AT,BY,BE,BA,BG,HR,CZ,DK,EE,FO,FI,FR,DE,GI,GR,GG,VA,HU,IS,IE,IM,IT,JE,LV,LI,LT,LU,MK,MT,MD,MC,ME,NL,NO,PL,PT,RO,RU,SM,RS,SK,SI,ES,SJ,SE,CH,UA,GB",
            "Africa" => "DZ,AO,BJ,BF,BI,CM,CV,CF,TD,KM,CD,CG,CI,DJ,EG,GQ,ER,ET,GA,GM,GH,GN,GW,KE,LS,LR,LY,MR,MU,YT,MG,MW,ML,MA,MZ,NA,NE,NG,RE,SH,RW,ST,SN,SC,SL,SO,ZA,SD,SZ,TZ,TG,TN,UG,EH,ZM,ZW",
            "Asia" => "AF,AM,AZ,BH,BD,BT,IO,BN,KH,CN,CX,CC,CY,GE,HK,IN,ID,IR,IQ,IL,JP,JO,KZ,KP,KR,KW,KG,LA,LB,MO,MY,MV,MN,MM,NP,OM,PK,PS,PH,QA,SA,SG,LK,SY,TW,TJ,TH,TL,TR,TM,AE,UZ,VN,YE",
            "Oceania" => "AS,AU,CK,FJ,PF,GU,KI,MH,FM,NR,NC,NZ,NU,NF,MP,PW,PG,PN,WS,SB,TK,TO,TV,UM,VU,WF",
            "Antarctica" => "AQ,BV,TF,HM,GS"
        );

        $r = new $reports["_TOP_COUNTRIES_CITIES"]["ClassName"]();
        $r->label = _TOP_COUNTRIES_CITIES;
        $r->from = $this->from;
        $r->to = $this->to;
        $d = $r->GetReportData();

        $newdata = [];

        foreach ($continents as $continent => $country) {
            $countrys = explode(",", $country);
            foreach ($d as $k => $v) {
                if (in_array($v[0], $countrys) !== false) {
                    $newdata[$continent][0] = $continent;
                    $newdata[$continent][1] = $v[1] + isset($newdata[$continent][1]);
                    $newdata[$continent][2] = $v[2] + isset($newdata[$continent][2]);
                    $newdata[$continent][3] = number_format(
                        ($newdata[$continent][1] == 0 ? 0 : ($newdata[$continent][2] / $newdata[$continent][1])),
                        2
                    );
                }
            }
        }

        $data = [];
        $i = 0;
        foreach ($newdata as $nk => $nv) {
            $data[$i] = $nv;

            $i++;
        }

        return $data;
    }

    function UpdateStats($from = '', $to = '', $print = 2)
    {
        return false;
    }
}
