<?php

/**
* @desc Definitions for this report: Visitors per Day

    Visitors: Unique Visitors that accessed your site (excluding any bots and crawlers).
    Pageviews: The total number of pages requested (excluding any bots and crawlers).
    Average Pages per user: The total number of pages devided by the number of visitors.
*/

$reports["_TIME_ON_PAGE"] = Array(
	"ClassName" => "TimeOnPage", 
	"Category" => "_POPULAR_CONTENT", 	
	"Options" => "daterangeField,profileselector,columnSelector,trafficsource,displaymode,limit",
	"Filename" => "time_on_page",
	"Distribution" => "Premium",
	"Order" => 6,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false
	//"Update" => false
);

class TimeOnPage extends Report {
	
	function Settings(){
		
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table,linechart,barchart";
		$this->columnDefinitions[] = ["Label" => "_PAGE","actionmenu" => 'page'];
		$this->columnDefinitions[] = ["Label" => "_PAGEVIEWS"];
		$this->columnDefinitions[] = ["Label" => "0-10s"];
		$this->columnDefinitions[] = ["Label" => "10-60s"];
		$this->columnDefinitions[] = ["Label" => "1-5m"];
		$this->columnDefinitions[] = ["Label" => "5m-1h"];
		$this->columnDefinitions[] = ["Label" => "+1h"];
		$this->sort_key = 1;
		$this->sort_order = SORT_DESC;

		global $profile;
		include "includes/codespace.php";
		$this->help = _TIME_ON_PAGE_DESC.'<br><br>'._GIFDATA_REPORT_DESC."<br><br>"._REPORT_NEEDS_GIFDATA." "._TAG_LOGFILES."<br><br>".$codespace2;

		// get logaholic.gif id
		$this->gifid = getID("/logaholic.gif","urls");
		if ($this->gifid == false) { $this->gifid = 'false'; return false; }
		
	}

	function DefineQuery() {
		global $db;
		if ($this->gifid == 'false') { return false; }
		
		$q = subsetDataToSourceID("select a.referrer, CONVERT(lg_getparam('pagetime',u.params), SIGNED INTEGER) as pagetime from {$this->profile->tablename_gifdata} as a, {$this->profile->tablename_urlparams} as u where a.params=u.id and a.url={$this->gifid} and a.timestamp >= ". $db->quote($this->from) ." AND a.timestamp <= ". $db->quote($this->to)." and u.params like '%pagetime=%'", $this->trafficsource);

		$q="select r.referrer, count(*) hits, 
			SUM(IF(pagetime < 10000,1,0)) as ten, SUM(IF(pagetime < 10000,pagetime,0)) as tensum, 
			SUM(IF(pagetime >= 10000 AND pagetime < 60000,1,0)) as minute, SUM(IF(pagetime >= 10000 AND pagetime < 60000,pagetime,0)) as minutesum,
			SUM(IF(pagetime >= 60000 AND pagetime < 300000,1,0)) as fivemin, SUM(IF(pagetime >= 60000 AND pagetime < 300000,pagetime,0)) as fiveminsum,
			SUM(IF(pagetime >= 300000 AND pagetime < 3600000,1,0)) as hour, SUM(IF(pagetime >= 300000 AND pagetime < 3600000,pagetime,0)) as hoursum, 
			SUM(IF(pagetime >= 3600000,1,0)) as overhour, SUM(IF(pagetime >= 3600000,pagetime,0)) as overhoursum,
			SUM(pagetime) from ($q) as a, {$this->profile->tablename_referrers} as r where a.referrer=r.id and pagetime > 0 group by r.referrer order by hits desc";

		$this->applytrafficsource = false;
		return $q;
	}	
	
	function GetReportData() {
		
		$data = parent::GetReportData();		
		$newdata = [];
		foreach($data as $k => $v) {
			$url = parse_url($v[0]);
			$data[$k][0] = $url['path'];			
			if (empty($data[$k][0])) { $data[$k][0] = $v[0]; }			
			($data[$k][3]>0 ? ($data[$k][3] = ($v[3] / $v[2])/1000) : 0);
			$data[$k][2] = "<span title='"._AVG_TIME_ON_PAGE.": ".$this->sec2time($data[$k][3])."'>".intval(($data[$k][2] / $data[$k][1]) * 100)."%</span>";
			($data[$k][5]>0 ? ($data[$k][5] = ($v[5] / $v[4])/1000) : 0);
			$data[$k][4] = "<span title='"._AVG_TIME_ON_PAGE.": ".$this->sec2time($data[$k][5])."'>".intval(($data[$k][4] / $data[$k][1]) * 100)."%</span>";
			($data[$k][7]>0 ? ($data[$k][7] = ($v[7] / $v[6])/1000) : 0);
			$data[$k][6] = "<span title='"._AVG_TIME_ON_PAGE.": ".$this->sec2time($data[$k][7])."'>".intval(($data[$k][6] / $data[$k][1]) * 100)."%</span>";
			($data[$k][9]>0 ? ($data[$k][9] = ($v[9] / $v[8])/1000) : 0);
			$data[$k][8] = "<span title='"._AVG_TIME_ON_PAGE.": ".$this->sec2time($data[$k][9])."'>".intval(($data[$k][8] / $data[$k][1]) * 100)."%</span>";
			($data[$k][11]>0 ? ($data[$k][11] = ($v[11] / $v[10])/1000) : 0);
			$data[$k][10] = "<span title='"._AVG_TIME_ON_PAGE.": ".$this->sec2time($data[$k][11])."'>".intval(($data[$k][10] / $data[$k][1]) * 100)."%</span>";

			$newdata[$k][0] = $data[$k][0];
			$newdata[$k][1] = $data[$k][1];
			$newdata[$k][2] = $data[$k][2];
			$newdata[$k][3] = $data[$k][4];
			$newdata[$k][4] = $data[$k][6];
			$newdata[$k][5] = $data[$k][8];
			$newdata[$k][6] = $data[$k][10];

			
		}		
		return $newdata;
	}

	function UpdateStats($from = '', $to = '',$print = 2){
		return false;
	}
}