<?php

/**
* @desc This report displays a trend of your search engines
*/
$reports["_SEARCH_ENGINE_TRENDS"] = Array(
	"ClassName" => "SearchEngineTrends", 
	"Category" => "_TRAFFIC_SOURCES", 
	"icon" => "images/icons/32x32/searchtrends.png",
	"Options" => "daterangeField,profileselector,trafficsource,period,displaymode,limit",
	"Filename" => "search_engine_trends",
	"Distribution" => "Premium",
	"Order" => 9,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => false,
	"Update" => false,
	"canAggregate" => true
);

class SearchEngineTrends extends Report {

	function Settings() {
		$this->DefaultDisplay = "areachart";
		$this->DisplayModes = "table,linechart,areachart";
		$this->help = _SEARCH_ENGINES_TRENDS_DESC;
		$this->displayReportButtons = false;
		$this->remove_outputmodes = array("xml");		
		if(empty($this->period)){ $this->period = '_DAYS';  }
		$this->chartoptions = array("stacked_graph_style" => "stack", "stacked_showcontrols" => false, "showlegend" => true);
		$this->addlabel .= _GROUPED_BY . " ".constant($this->period);
		$this->sort=false;

		// this is for the aggregation framework
		if (isset($this->limit)) {
			$this->limit_per_day = $this->limit;	
		} else {
			$this->limit_per_day = 10;
		}		
	}

	function GetReportData() {

		$data = $this->rawGetReportData();

		$data = $this->ConvertData($data);
		return $data;	

	}

	function rawGetReportData() {
		global $reports;
		$r = new $reports["_SEARCH_ENGINES"]["ClassName"]();
		$r->dataCollectType = "days";
		$r->createDataFiles($this->from,$this->to);	
		$d = $r->getTrendDataFromFiles($r->DataFiles($this->from,$this->to));
		$data = [];
			
		foreach($d as $k => $v){
			$l = 0;
			if(empty($v)) { continue; }
			foreach($v as $val){		
				if ($this->limit < 50 && $l > ($this->limit * 5)){
					break;
				} else if ($this->limit >= 50 && $l > ($this->limit * 2)){
					break;
				}
				@$timestamp = mktime(0,0,0,substr($k,4,-2),substr($k,6,7),substr($k,0,4));
				
				$engine = $val[0];
				$visits = $val[1];
				
				# Define the chosen period / time unit
				if ($this->period == '_DAYS') { 
					$format = "D, m/d/Y";
					$date = date($format,$timestamp);
					
				} else if ($this->period == '_WEEKS') {
					$format = "Y-#W";
					$date = date($format,$timestamp);
					$date = str_replace("#","W",$date);
				} else if ($this->period == '_MONTHS') {
					$format = "M Y";
					$date = date($format,$timestamp);
				}				
				
				if(isset($data[$engine][$date])) {				
					$data[$engine][$date] = $data[$engine][$date] + $visits;
				} else {	
					$data[$engine][$date] = $visits;
				}
				$l ++;
			}
		}
		
		$d = [];
		$i = 0;
		$l = 0;
		foreach($data as $engine => $v){
			if($l > $this->limit){
				break;
			}
			foreach($v as $date => $visits){
				$d[$i][0] = $date; 
				$d[$i][1] = $engine; 
				$d[$i][2] = $visits; 
				$i ++;
			}
			$l ++;
		}		
		return $d;
	}

	function ConvertData($data = "") {
		//if(empty($data)) { $data = $this->GetReportData(); }
		
		# transform the data array to a column for each serie
		$data = $this->seriesToColumns($data);
		
		if(empty($data)) {
			return $this->EmptyTrendData();
		}
		
		foreach($data['fields'] as $key => $countrycode) { // Convert country codes to countries
			if(isset($cnames[$countrycode])) {
				$data['fields'][$key] = $cnames[$countrycode];
			}
		}
		
		foreach($data['fields'] as $f){
			$this->columnDefinitions[] = array("Label" => $f);
		}
		$this->setupColumnDefinitions();
		
		# create an empty seed array with the right dimensions
		$ncols = count($data['fields']);
		$nrows = $this->dateNumber($this->from, $this->to, $this->period);
		
		$seed_data = $this->newReportArray($nrows, $ncols);
		# add a date to he first value of each row.
		$seed_data = $this->AddDateToZeroArray($seed_data);
		
		# merge the actual results with the seed_data array
		foreach ($data['data'] as $key => $val) {
			if($this->period == '_WEEKS'){
				$dparts = explode("-",$key);
				$year = mktime(0,0,0,1,1,$dparts[0]);
				$week = str_replace("W","",$dparts[1]);
			
				$timestamp = (86400 * 7 * $week) + $year;		
			} else {
				$timestamp = strtotime($key);
			}
			
			$day_id = $this->dateNumber($this->from,$timestamp, $this->period);
			
			for ($i = 0; $i < $ncols; $i++) {
				if (isset($val[$i])) {
					$seed_data[$day_id][$i] = $val[$i];
				}
			}		
		}	
		ksort($seed_data);
		
		# now make sure the date column is properly filled
		foreach($seed_data as $key => $value) {
			$value[0] = $this->getFormatDate($this->period,($this->from+(($key)*$this->getSeconds($this->period))));
			$seed_data[$key] = $value;
		}
		
		return $seed_data;
	}
	
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		# not using datafiles yet
		return false;		
	}
}
?>