<?php

/**
* @desc This report displays the most active visitors
*/
$reports["_MOST_ACTIVE_USERS"] = Array(
	"ClassName" => "MostActiveVisitors", 
	"Category" => "_VISITOR_DETAILS", 
	"icon" => "images/icons/32x32/mostactivevisitors.png",
	"Options" => "daterangeField,profileselector,displaymode,trafficsource,search,country_list,limit,columnSelector,human",
	"Filename" => "most_active_visitors",
	"Distribution" => "Premium",
	"Order" => 5,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true
);

class MostActiveVisitors extends Report {

	function Settings() {		
		
		$this->DefaultDisplay = "table";
		$this->DisplayModes = "table";
		$this->columnDefinitions[] = array("Label" => "_IP_NUMBER","actionmenu" => 'ip', "search" => true);
		$this->columnDefinitions[] = array("Label" => "_REQUESTS");
		$this->columnDefinitions[] = array("Label" => "_COUNTRY","actionmenu" => 'country');
		$this->columnDefinitions[] = array("Label" => "_MEGABYTES");
		$this->sort_order = SORT_DESC;
		$this->sort_key = 1;

		if (isset($this->country_list)) {
			$this->addlabel .= $this->country_list;
		}
	}
	function DefineQuery() {
		global $db;
		
		if (isset($this->human) && $this->human==1) {
			$tablename = $this->profile->tablename_merge;			
		} else {
			$tablename = $this->profile->tablename;
		}

		$subquery  = "select visitorid,count(*) as hits,country,(sum(bytes*1.00)/1024.0)/1024.0 as mb from {$tablename} where timestamp >= ". $db->quote($this->from) ." and timestamp <= ". $db->quote($this->to) ." group by visitorid,country order by hits desc";
		$subquery = subsetDataToSourceID($subquery, $this->trafficsource);
		$this->applytrafficsource = false;
		$query = "SELECT concat(v.ipnumber,'##',v.visitorid,'##',v.customlabel), hits, country, mb FROM ({$subquery}) as a, {$this->profile->tablename_visitorids} as v where a.visitorid=v.id "; 
		
		
		return $query;
	}

	function DisplayReport() {
		//dump($this);
		parent::DisplayReport();
	}
	
	function UpdateStats($from = '', $to = '',$print = 2){
		# not important enough
		return false;
	}
}
?>
