<?php

$reports["_COMPARE_DAYS"] = Array(
	"ClassName" => "CompareDays", 
	"Category" => "_VISITOR_TRENDS", 
	"icon" => "images/icons/32x32/todayoverview.png",
	"Options" => "daterangeField,profileselector,human",
	"Filename" => "compare_days",
	"Distribution" => "Premium",
	"Order" => 10,
	"ReportVersion" => 1.0,
	"MinimumVersion" => 3.0,
	"EmailAlerts" => true,
	"Update" => false	
);

class CompareDays extends Report {

	function Settings() {
		
		$this->allowDateFormat = false;
		$this->sort = false;
		$this->DisplayModes = "table,barchart";
        $this->DefaultDisplay = "barchart";
        $this->remove_outputmodes = array("xml");

		$this->columnDefinitions = [];		
		$this->columnDefinitions[] = array("Label" => _DAYS);
		$this->columnDefinitions[] = array("Label" => "3 "._WEEKS_AGO);
		$this->columnDefinitions[] = array("Label" => "2 "._WEEKS_AGO);
		$this->columnDefinitions[] = array("Label" => "1 "._WEEK_AGO);
		$this->columnDefinitions[] = array("Label" => _THIS_WEEK);

		// lets override the date range so it is always 3 weeks + whatever days in this week
		$monday = strtotime("Monday this week", $this->to);
		$from_3weeks_ago = strtotime("-3 weeks", $monday);
		$_POST['from'] = $this->from = mktime(0, 0, 0, date("m", $from_3weeks_ago), date("d", $from_3weeks_ago), date("Y", $from_3weeks_ago));
		$_POST['to'] = $this->to = mktime(23,59,59,date("m", $this->to),date("d", $this->to),date("Y", $this->to));		
		$this->addlabel .= " "._COMPARE_WEEKDAYS_DATERANGE_ADJUST." ".LogaDate(array("format1" => "l", "seperator1" => ", ", "format2" => "M", "seperator2" => " ", "format3" => "d"), $this->to);

	}

	function GetReportData() {
		global $reports;
		
		# Get Visitor per day data for entire range
		$r = new $reports["_VISITORS_PER_DAY"]["ClassName"]();
		$r->label = _VISITORS_PER_DAY;
		$r->from = $this->from;
		$r->to = $this->to;
		$r->dataCollectType = "days";
		$this->days = $r->GetReportData();
				
		$graphdata = $this->newReportArray(7,5);


		$prefill = [];
		$prefill[] = _MONDAY;
		$prefill[] = _TUESDAY;
		$prefill[] = _WEDNESDAY;
		$prefill[] = _THURSDAY;
		$prefill[] = _FRIDAY;
		$prefill[] = _SATERDAY;
		$prefill[] = _SUNDAY;
		
		$i=0;
		foreach($graphdata as $k => $v) {
			$graphdata[$k][0] = $prefill[$k];						
		}

		$allowedWeeks[date("W Y", mktime( 0,0,0,date("m",$this->to),date("d",$this->to) - 21,date("y",$this->to) ) )] = 1;
		$allowedWeeks[date("W Y", mktime( 0,0,0,date("m",$this->to),date("d",$this->to) - 14,date("y",$this->to) ) )] = 2;
		$allowedWeeks[date("W Y", mktime( 0,0,0,date("m",$this->to),date("d",$this->to) - 7,date("y",$this->to) ) )] = 3;
		$allowedWeeks[date("W Y", $this->to)] = 4;
		
		$i=0;
		foreach($this->days as $day) {
			$w = date("W Y",strtotime($day[0]));
			if( isset($allowedWeeks[$w]) ) {
				$w = $allowedWeeks[$w]; 
				$graphdata[$i][0] = $prefill[$i];
				$graphdata[$i][$w] = $graphdata[$i][$w] + $day[4]; // use visits
			} 
			$i++;
			if ($i==7) { $i =0; }
		}
		
		$this->graphcolors[0] = "#9ECAE1";
		$this->graphcolors[1] = "#6baed6";
		$this->graphcolors[2] = "#3182bd";
		$this->graphcolors[3] = "#d62728";
		
		
		$this->barchartcolors = $this->graphcolors;			
		return $graphdata;		
	}
	
		
	function DisplayCustomForm() {
		
		echo "<div class='form-group'>"._COMPARE_WEEKDAYS_DATERANGE_NOTICE."</div>";

		return;
		
	}
	
	
	function UpdateStats($from = '', $to = '',$print = 2) {
		return false;
	}
}
?>
