<?php

include_once("../../AccessControl.php");

include_once "../../includes/logparser.inc.php"; 


# if we are checking an ftp path, do this
if (isset($_REQUEST['ftpserver']) && file_exists("../../includes/FTP_log_class.php") ) {
    
	$msg ="";

    include "../../includes/FTP_log_class.php";
    $ftp = new FTP_log($_REQUEST['ftpserver'], $_REQUEST['ftpuser'], $_REQUEST['ftppasswd'], $_REQUEST['ftpfullpath'], $_REQUEST['splitfilter'], $_REQUEST['splitfilternegative'], "", "", $_REQUEST['ftpport'], $_REQUEST['ftpmode']);
	
    $filelist = $ftp->GetFileList($_REQUEST['ftpfullpath']);
	
	$filelist = $ftp->DecodeFilesData($filelist);
	//dump($filelist);
    $filtered = $ftp->FilterFileList($filelist);
	if(empty($filtered)) {
		$filtered = array();
	}
	
    if ($filelist==false) {
    	$msg = _CANT_READ_DIR . ": ".$_REQUEST['ftpfullpath'];
        $data = array("Status" => "Success", "Message" => $msg, "Type" => 'dir');
		echo json_encode($data);
		
    } else if (empty($filelist)) {
    	$msg = _NO_FILES_IN . ": ".$_REQUEST['ftpfullpath'];
    	$data = array("Status" => "Success", "Message" => $msg, "Type" => 'dir');
		echo json_encode($data);
		
    } else {        
		$res = array();
		$i=0;

		$back = explode("/",$_REQUEST['ftpfullpath']);
		array_pop($back);
		$back = implode("/",$back);
		if ($back=="") { $back = "/"; }
        $fullpath=$back;

		//first row is always dir back
		$res[$i][0] = "<span class=\"loghint_file\" data-fullfile=\"$back\"><i class=\"fa fa-folder-o\"> </i>  <u>..</u></span>";
		$res[$i][1] = "";
		$res[$i][2] = "DIR";
		$res[$i][3] = "";
		$i++;

        foreach($filelist as $file) {
        	$path = $_REQUEST['ftpfullpath'];
        	if(substr($path,-1) == "/"){
        		$path = substr($path,0, -1);
        	}
        	$fullpath = "$path/$file";

        	if ($file==".") {
        		continue;
        	}
			if ($file=="..") {
				continue;
        	}        	


        	if ($ftp->full_file_data_list[$file]['isDir'] == 1) {
        		$icon = "<i class=\"fa fa-folder-o\"> </i>";
        		$link = "loghint_file";
        	} else {
        		$icon = "<i class=\"fa fa-file-o\"> </i>";
        		$link = "";
        	}

        	if (in_array($path . "/" . $file, $filtered)) { 

                $res[$i][0] = "<span class=\"$link\" data-fullfile=\"$fullpath\">$icon  ".$file."</span>";
            } else if (in_array($file, $filtered)) {
                $res[$i][0] = "<span class=\"$link\" data-fullfile=\"$fullpath\">$icon  ".$file."</span>";
            } else {
            	if ($ftp->full_file_data_list[$file]['isDir'] == 0) {
                	$res[$i][0] = "<span class=\"gray\" title=\"". _DOES_NOT_MATCH_FILTER ."\">$icon  ".$file."</span>";
                } else {
                	
                	$res[$i][0] = "<span class=\"$link\" data-fullfile=\"$fullpath\">$icon  ".$file."</span>";
                	
                }
            }

			$res[$i][1] = date(GetCustomDateFormat()." H:i:s",$ftp->full_file_data_list[$file]['timestamp']);
			
			$size = $ftp->full_file_data_list[$file]['bytes'];
			if ($size < 1024) {
				$res[$i][2] = $size . " b";
			} else if ($size > (1024*1024)) {
				$res[$i][2] = number_format(($size/1024/1024),2) ." mb";
			} else {
				$res[$i][2] = number_format(($size/1024),0). " kb";
			}
			$res[$i][3] = "";
			$i++;

        }
        
        $data = array("Status" => "Success", "Message" => $msg, "Type" => 'dir', "data" => $res);
		echo json_encode($data);
        
    }
    exit();    
}


# do the rest of this script in case we are checking local paths
$q = (isset($_GET["q"])) ? $_GET["q"] : die("Missing parameters!");
//check log file
$q=urldecode($q);
$q=stripslashes($q);
if (empty($q)) {
	//$real_path = realpath("../index.php");
	//$rpath = dirname($real_path);
	$rpath = logaholic_dir();
	$msg = _FULL_ABSOLUTE_PATH_TO_LOGAHOLIC_DIR . ": <font color=green>$rpath/</font><br>" . _LOGFILE_USUALLY_FEW_DIRS_BACK . ".";
	$data = array("Status" => "Warning", "Message" => $msg);
	echo json_encode($data);
	exit();
}
if (file_exists($q)) {
	if (is_dir($q)) {
		$msg = "";

		// clean any traling slash and figure out the level up dir
		if (substr($q, -1, 1) == "/") {
			$q = substr($q, 0, -1);
		}
		$back = explode("/", $q);
		array_pop($back);
		$back = implode("/", $back);
		if ($back == "") {
			$back = "/";
		}
		$q = $q . "/";


		if (!is_readable($q)) {
			$msg = _CANT_READ_DIR . ": $q";
			$files = array();
			$dirs = array();
		} else {
			$files = glob("{$q}*");
			if ($files == false) {
				$msg = _NO_FILES_IN . ": $q";
				$files = array();
			}
			$dirs = glob("{$q}*", GLOB_ONLYDIR);
			if ($dirs == false) {
				$dirs = array();
			}
		}

		$i = 0;
		$res = array();

		//first row is always dir back
		$res[$i][0] = "<span class=\"loghint_file\" data-fullfile=\"$back\"><i class=\"fa fa-folder-o\"> </i>  <u>..</u></span>";
		$res[$i][1] = date(GetCustomDateFormat()." H:i:s",filemtime($back));
		$res[$i][2] = "DIR";
		$res[$i][3] = substr(sprintf('%o', fileperms($back)), -4);
        $i++;

		foreach($dirs as $dir){
			//echo $dir."<br>";
			$fullfile = $dir;
			$file = str_replace($q, "", $dir);
			$res[$i][0] = "<span class=\"loghint_file\" data-fullfile=\"$fullfile\"><i class=\"fa fa-folder-o\"> </i>  <u>" . $file . "</u></span>";
			//$res[$i][0] = "/".$file;
			$res[$i][1] = date(GetCustomDateFormat() . " H:i:s", filemtime($fullfile));
			$res[$i][2] = "DIR";
			$res[$i][3] = substr(sprintf('%o', fileperms($fullfile)), -4);
			$i++;
		}

		foreach ($files as $file) {
			$fullfile = $file;
			$file = str_replace($q, "", $file);

			if (is_dir($fullfile)) {
				//$i++;
				continue;
			}


			if (isset($_REQUEST['splitfilter']) && preg_match("[" . $_REQUEST['splitfilter'] . "]", $file) > 0) {
				if (!empty($_REQUEST['splitfilternegative']) && preg_match(
						"[" . $_REQUEST['splitfilternegative'] . "]",
						$file
					) > 0) {
					$res[$i][0] = "<span class=\"gray\" title=\"" . _DOES_NOT_MATCH_FILTER . "\"><i class=\"fa fa-file-o\"> </i>  " . $file . "</span>";
				} else {
					$res[$i][0] = "<span class=\"loghint_file\" data-fullfile=\"$fullfile\"><i class=\"fa fa-file-o\"> </i>  " . $file . "</span>";
				}
			} else {
				$res[$i][0] = "<span class=\"gray\" title=\"" . _DOES_NOT_MATCH_FILTER . "\"><i class=\"fa fa-file-o\"> </i>  " . $file . "</span>";
			}


			$res[$i][1] = date(GetCustomDateFormat() . " H:i:s", filemtime($fullfile));

			$size = filesize($fullfile);
			if ($size < 1024) {
				$res[$i][2] = $size . " b";
			} else {
				if ($size > (1024 * 1024)) {
					$res[$i][2] = number_format(($size / 1024 / 1024), 2) . " mb";
				} else {
					$res[$i][2] = number_format((filesize($fullfile) / 1024), 0) . " kb";
				}
			}
			$res[$i][3] = substr(sprintf('%o', fileperms($fullfile)), -4);
			
			$i++;
		}		
		
		$data = array("Status" => "Success", "Message" => $msg, "Type" => 'dir', "data" => $res);
		echo json_encode($data);
		
		
	} else if (filetype($q)=="file") {


		$msg="";
		$lfown=fileowner($q);
		$lfperm=substr(sprintf('%o', fileperms($q)), -4);

		$lfmb = filesize($q);
		if ($lfmb < 1024) {
			$lfmb = $lfmb . " b";
		} else {
			if ($lfmb > (1024 * 1024)) {
				$lfmb = number_format(($lfmb / 1024 / 1024), 2) . " mb";
			} else {
				$lfmb = number_format(($lfmb / 1024), 0) . " kb";
			}
		}

		$msg .= "<b><font color=gray>" . _FILE_INFO . ":</font></b><br>" . _LOG_FILE_LOCATION . ": <font color=green>$q</font><br>";
		$msg .= _SIZE . ": $lfmb <br>";

		if (isset($_ENV['OS']) != "Windows_NT") {
			if (extension_loaded('posix')) {
				$list = posix_getpwuid($lfown);
				$lfown = $list['name'];
			}
			$msg .= _OWNER . ": $lfown<br>";
			$msg .= _PERMISSIONS . ": $lfperm<br>";
		}

		$msg .= _ACCESS_CHECK . ": ";
		if (is_readable($q)) {
			$msg .= _FILE_IS_READABLE . '<br>';

			$logFormat = formatOfLogFile($q);

			if ($logFormat) {
				$msg .= '<font color=green>' . _VALID_LOGFILE_FORMAT_OF_TYPE . ' <b>' . $logFormat["Description"] . '</b></font>';
			} else {
				$msg .= '<font color=red><b>'._FILE_IS_NOT_OF_A_KNOWN_LOGFILE_TYPE.'.</b></font>';
			}
		} else {
			$msg .= _FILE_IS_NOT_READABLE.'<br>';
		}
		$msg .= "";

		$path_parts = pathinfo($q);
		//first row is always dir back
		$res[0][0] = "<span class=\"loghint_file\" data-fullfile=\"".$path_parts['dirname']."\"><i class=\"fa fa-folder-o\"> </i>  <u>..</u></span>";
		$res[0][1] = date(GetCustomDateFormat()." H:i:s",filemtime($path_parts['dirname']));
		$res[0][2] = "DIR";
		$res[0][3] = substr(sprintf('%o', fileperms($path_parts['dirname'])), -4);

		$data = array("Status" => "Success", "Message" => $msg, "Type" => 'file', "data" => $res);
		echo json_encode($data);

	}
} else {
	$data = array("Status" => "Warning", "Message" => _LOCATION_DOES_NOT_EXISTS, "Type" => 'file');
	echo json_encode($data);
}
?>
